<?php
/**
 * User Upload Page (with Progress Bar)
 *
 * This is Step 1 of the AI interview process, where the user uploads
 * their CV and the job advertisement they are applying for.
 */

// The main router (index.php) handles session and security checks.
include THEME_PATH . 'header.php'; // Includes the main header

?>

<div class="user-dashboard">
    <div class="container">
        <div class="upload-container">
            <div class="upload-header">
                <div class="step-icon active">1</div>
                <h1><?php echo trans('step_1_title'); ?></h1>
                <p><?php echo trans('step_1_description'); ?></p>
            </div>

            <!-- Session Message Display -->
            <?php if (isset($_SESSION['upload_error'])): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?php echo e($_SESSION['upload_error']); unset($_SESSION['upload_error']); ?>
                </div>
            <?php endif; ?>

            <form action="actions/upload_handler.php" method="POST" enctype="multipart/form-data" class="upload-form" id="upload-form">
                
                <!-- CV Upload Section -->
                <div class="form-group-upload">
                    <label for="cv_file" class="upload-label">
                        <i class="fas fa-file-invoice"></i>
                        <span>Upload Your CV</span>
                        <small>PDF, DOC, DOCX, JPG, PNG (Max 2MB)</small>
                    </label>
                    <input type="file" id="cv_file" name="cv_file" class="file-input" required>
                    <span id="cv_file_name" class="file-name-display">No file chosen</span>
                </div>

                <!-- Job Ad Upload Section -->
                <div class="form-group-upload">
                    <label for="job_ad_file" class="upload-label">
                        <i class="fas fa-briefcase"></i>
                        <span>Upload Job Advertisement</span>
                        <small>PDF, DOC, DOCX, TXT, JPG, PNG (Max 2MB)</small>
                    </label>
                    <input type="file" id="job_ad_file" name="job_ad_file" class="file-input" required>
                     <span id="job_ad_file_name" class="file-name-display">No file chosen</span>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary btn-submit-upload">
                        <i class="fas fa-cloud-upload-alt"></i> Analyze & Proceed
                    </button>
                    <a href="index.php?page=dashboard" class="btn btn-secondary">Back to Dashboard</a>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Progress Bar Overlay (consistent with admin panel) -->
<div class="progress-overlay" id="progress-overlay" style="display: none;">
    <div class="progress-container">
        <h2 class="progress-title">Uploading Files...</h2>
        <p class="progress-text">
            Your documents are being securely uploaded and prepared for analysis. Please wait a moment.
        </p>
        <div class="progress-bar-animated"></div>
    </div>
</div>


<style>
/* Add specific styles for the upload page for a better UX */
.upload-container {
    max-width: 700px;
    margin: 40px auto;
    background: var(--card-bg);
    padding: 40px;
    border-radius: 12px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
}
.upload-header {
    text-align: center;
    margin-bottom: 30px;
}
.upload-header .step-icon {
    margin: 0 auto 15px auto;
}
.upload-header h1 {
    font-size: 28px;
    margin: 0 0 10px 0;
}
.upload-form {
    display: flex;
    flex-direction: column;
    gap: 25px;
}
.form-group-upload {
    position: relative;
    border: 2px dashed var(--border-color);
    border-radius: 12px;
    padding: 30px;
    text-align: center;
    transition: all 0.3s ease;
}
.form-group-upload:hover {
    border-color: var(--primary-color);
    background-color: #f8f9fa;
}
.upload-label {
    cursor: pointer;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
}
.upload-label i {
    font-size: 36px;
    color: var(--primary-color);
}
.upload-label span {
    font-weight: 600;
    font-size: 18px;
}
.upload-label small {
    color: var(--text-secondary);
}
.file-input {
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    opacity: 0;
    cursor: pointer;
}
.file-name-display {
    margin-top: 15px;
    font-style: italic;
    color: var(--text-secondary);
    font-size: 14px;
}
.btn-submit-upload {
    font-size: 18px;
    padding: 15px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // JS to show the chosen file name for better UX
    document.getElementById('cv_file').addEventListener('change', function() {
        const fileName = this.files[0] ? this.files[0].name : 'No file chosen';
        document.getElementById('cv_file_name').textContent = fileName;
    });
    document.getElementById('job_ad_file').addEventListener('change', function() {
        const fileName = this.files[0] ? this.files[0].name : 'No file chosen';
        document.getElementById('job_ad_file_name').textContent = fileName;
    });

    // JS to show the progress bar on form submission
    const uploadForm = document.getElementById('upload-form');
    const progressOverlay = document.getElementById('progress-overlay');
    if (uploadForm && progressOverlay) {
        uploadForm.addEventListener('submit', function() {
            // Basic validation to ensure files are selected
            if (document.getElementById('cv_file').files.length === 0 || document.getElementById('job_ad_file').files.length === 0) {
                // The 'required' attribute on the inputs should prevent this, but it's a good fallback.
                return; 
            }
            progressOverlay.style.display = 'flex';
        });
    }
});
</script>

<?php
// Include the standard user footer.
include THEME_PATH . 'footer.php';
?>

