<?php
/**
 * User Registration Page
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// REMOVED: require_once '../../config.php';  <- This was causing errors.
// REMOVED: require_once '../../app/helpers.php'; <- This was also incorrect.

if (is_logged_in()) {
    header('Location: index.php?page=dashboard');
    exit();
}

$form_data = $_SESSION['form_data'] ?? [];
unset($_SESSION['form_data']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - <?php echo e(SITE_NAME); ?></title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Main Stylesheet for Auth Pages (shares styles with login.php) -->
    <style>
        /* This CSS is identical to login.php for consistency. In a real project, this would be in a shared CSS file. */
        body { font-family: 'Poppins', sans-serif; background-color: #f0f2f5; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; padding: 20px; box-sizing: border-box; }
        .auth-container { background-color: #ffffff; padding: 40px; border-radius: 12px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1); width: 100%; max-width: 420px; text-align: center; }
        .auth-header h1 { margin: 0 0 10px 0; font-size: 28px; color: #333; font-weight: 700; }
        .auth-header p { margin: 0 0 30px 0; color: #777; }
        .form-group { margin-bottom: 20px; text-align: left; }
        .form-control { width: 100%; padding: 12px 15px; border-radius: 8px; border: 1px solid #ddd; font-size: 16px; box-sizing: border-box; }
        .btn { width: 100%; padding: 14px; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; transition: background-color 0.3s, color 0.3s; }
        .btn-primary { background-color: #4A90E2; color: white; }
        .btn-primary:hover { background-color: #357ABD; }
        .btn-google { background-color: #fff; color: #555; border: 1px solid #ddd; display: flex; align-items: center; justify-content: center; gap: 10px; }
        .btn-google:hover { background-color: #f7f7f7; }
        .divider { display: flex; align-items: center; text-align: center; color: #aaa; margin: 30px 0; }
        .divider::before, .divider::after { content: ''; flex: 1; border-bottom: 1px solid #ddd; }
        .divider:not(:empty)::before { margin-right: .25em; }
        .divider:not(:empty)::after { margin-left: .25em; }
        .auth-footer { margin-top: 20px; color: #555; }
        .auth-footer a { color: #4A90E2; text-decoration: none; font-weight: 600; }
        .alert { padding: 15px; margin-bottom: 20px; border-radius: 8px; font-size: 14px; text-align: left; }
        .alert-danger { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .alert-danger ul { margin: 0; padding-left: 20px; }
    </style>
</head>
<body>

    <div class="auth-container">
        <div class="auth-header">
            <h1>Create Your Account</h1>
            <p>Get started with your AI-powered interview preparation.</p>
        </div>

        <!-- Display Validation Errors -->
        <?php if (isset($_SESSION['error_messages'])): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php foreach ($_SESSION['error_messages'] as $error): ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php unset($_SESSION['error_messages']); ?>
        <?php endif; ?>

        <form action="actions/user_register_handler.php" method="POST">
            <div class="form-group">
                <input type="text" name="full_name" class="form-control" placeholder="Full Name" value="<?php echo e($form_data['full_name'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <input type="email" name="email" class="form-control" placeholder="Email Address" value="<?php echo e($form_data['email'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <input type="password" name="password" class="form-control" placeholder="Password (min. 8 characters)" required>
            </div>
            <div class="form-group">
                <input type="password" name="confirm_password" class="form-control" placeholder="Confirm Password" required>
            </div>
            <button type="submit" class="btn btn-primary">Create Account</button>
        </form>

        <div class="divider">OR</div>

        <a href="google_sso.php" class="btn btn-google">
            <img src="https://www.google.com/favicon.ico" alt="Google icon" width="20" height="20">
            Sign Up with Google
        </a>

        <div class="auth-footer">
            Already have an account? <a href="index.php?page=login">Sign In</a>
        </div>
    </div>

</body>
</html>

