<?php
/**
 * Forgot Password Page
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// REMOVED: require_once '../../config.php';  <- This was causing errors.
// REMOVED: require_once '../../app/helpers.php'; <- This was also incorrect.

if (is_logged_in()) {
    header('Location: index.php?page=dashboard');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - <?php echo e(SITE_NAME); ?></title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Main Stylesheet for Auth Pages (shares styles with login.php) -->
    <style>
        /* This CSS is identical to login.php for consistency. In a real project, this would be in a shared CSS file. */
        body { font-family: 'Poppins', sans-serif; background-color: #f0f2f5; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; padding: 20px; box-sizing: border-box; }
        .auth-container { background-color: #ffffff; padding: 40px; border-radius: 12px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1); width: 100%; max-width: 420px; text-align: center; }
        .auth-header h1 { margin: 0 0 10px 0; font-size: 28px; color: #333; font-weight: 700; }
        .auth-header p { margin: 0 0 30px 0; color: #777; }
        .form-group { margin-bottom: 20px; text-align: left; }
        .form-control { width: 100%; padding: 12px 15px; border-radius: 8px; border: 1px solid #ddd; font-size: 16px; box-sizing: border-box; }
        .btn { width: 100%; padding: 14px; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; transition: background-color 0.3s, color 0.3s; }
        .btn-primary { background-color: #4A90E2; color: white; }
        .btn-primary:hover { background-color: #357ABD; }
        .auth-footer { margin-top: 20px; color: #555; }
        .auth-footer a { color: #4A90E2; text-decoration: none; font-weight: 600; }
        .alert { padding: 15px; margin-bottom: 20px; border-radius: 8px; font-size: 14px; text-align: left; }
        .alert-danger { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>

    <div class="auth-container">
        <div class="auth-header">
            <h1>Forgot Your Password?</h1>
            <p>No problem. Enter your email below and we'll send you a link to reset it.</p>
        </div>

        <!-- Display Messages -->
        <?php if (isset($_SESSION['error_message'])): ?>
            <div class="alert alert-danger"><?php echo e($_SESSION['error_message']); unset($_SESSION['error_message']); ?></div>
        <?php endif; ?>
        
        <?php // Note: The success message for this form is shown on the login page after redirection. ?>

        <form action="actions/forgot_password_handler.php" method="POST">
            <div class="form-group">
                <input type="email" name="email" class="form-control" placeholder="Enter your email address" required autofocus>
            </div>
            <button type="submit" class="btn btn-primary">Send Reset Link</button>
        </form>

        <div class="auth-footer">
            Remember your password? <a href="index.php?page=login">Sign In</a>
        </div>
    </div>

</body>
</html>

