<?php
/**
 * Admin Header
 *
 * PERBAIKAN:
 * 1. SEMUA link di sidebar (Dashboard, Users, Tests, dll.)
 * sekarang menggunakan link ABSOLUT (SITE_URL) untuk
 * menghentikan bug 'actions/' yang menumpuk.
 * 2. Memperbaiki link CSS agar absolut juga.
 * 3. Memastikan class 'admin-main-content' sudah benar.
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$current_page = $_GET['page'] ?? 'dashboard';

// Fungsi 'e' sederhana untuk echo htmlspecialchars
if (!function_exists('e')) {
    function e($string) {
        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo e(SITE_NAME); ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="<?php echo e(SITE_URL); ?>/public/themes/default/css/style.css">
</head>
<body class="admin-body">

    <aside class="admin-sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-brain icon"></i> AInterview ID</h2>
        </div>
        <ul class="admin-nav">
            <li>
                <a href="<?php echo e(SITE_URL); ?>/admin/index.php?page=dashboard" class="<?php echo ($current_page === 'dashboard') ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt nav-icon"></i> Dashboard
                </a>
            </li>
            <li>
                <a href="<?php echo e(SITE_URL); ?>/admin/index.php?page=users" class="<?php echo in_array($current_page, ['users', 'add_user', 'edit_user']) ? 'active' : ''; ?>">
                    <i class="fas fa-users nav-icon"></i> User Management
                </a>
            </li>
            <li>
                <a href="<?php echo e(SITE_URL); ?>/admin/index.php?page=tests" class="<?php echo in_array($current_page, ['tests', 'add_test', 'edit_test', 'manage_questions']) ? 'active' : ''; ?>">
                    <i class="fas fa-vial nav-icon"></i> Test Management
                </a>
            </li>
            <li>
                <a href="<?php echo e(SITE_URL); ?>/admin/index.php?page=learning" class="<?php echo ($current_page === 'learning') ? 'active' : ''; ?>">
                    <i class="fas fa-sync-alt nav-icon"></i> AI Learnings
                </a>
            </li>
            <li>
                <a href="<?php echo e(SITE_URL); ?>/admin/index.php?page=sessions" class="<?php echo ($current_page === 'sessions') ? 'active' : ''; ?>">
                    <i class="fas fa-history nav-icon"></i> Activity Log
                </a>
            </li>
        </ul>
        <div class="sidebar-footer">
            <a href="../logout.php?from=admin" class="sidebar-logout-link">
                <i class="fas fa-sign-out-alt nav-icon"></i> Logout
            </a>
        </div>
    </aside>

    <div class="admin-main-content">
        <header class="admin-header">
            <div class="admin-profile">
                <a href="#">
                    <i class="fas fa-user-circle"></i>
                    <?php echo e($_SESSION['admin_name'] ?? 'Admin'); ?>
                </a>
            </div>
        </header>

        ```