<?php
/**
 * Admin Header
 *
 * This file is included at the top of all admin pages.
 * It contains the HTML head, the sidebar navigation, and the top bar.
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$current_page = $_GET['page'] ?? 'dashboard';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo e(SITE_NAME); ?></title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Main Stylesheet -->
    <link rel="stylesheet" href="../public/themes/default/css/style.css">
</head>
<body class="admin-body">

    <!-- Admin Sidebar Navigation -->
    <aside class="admin-sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-brain icon"></i> AInterview ID</h2>
        </div>
        <ul class="admin-nav">
            <li>
                <a href="index.php?page=dashboard" class="<?php echo ($current_page === 'dashboard') ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt nav-icon"></i> Dashboard
                </a>
            </li>
            <li>
                <a href="index.php?page=users" class="<?php echo in_array($current_page, ['users', 'add_user', 'edit_user']) ? 'active' : ''; ?>">
                    <i class="fas fa-users nav-icon"></i> User Management
                </a>
            </li>
            <li>
                <a href="index.php?page=tests" class="<?php echo in_array($current_page, ['tests', 'add_test', 'edit_test', 'manage_questions']) ? 'active' : ''; ?>">
                    <i class="fas fa-vial nav-icon"></i> Test Management
                </a>
            </li>
            <li>
                <a href="index.php?page=learning" class="<?php echo ($current_page === 'learning') ? 'active' : ''; ?>">
                    <i class="fas fa-sync-alt nav-icon"></i> AI Learnings
                </a>
            </li>
            <li>
                <a href="index.php?page=sessions" class="<?php echo ($current_page === 'sessions') ? 'active' : ''; ?>">
                    <i class="fas fa-history nav-icon"></i> Activity Log
                </a>
            </li>
        </ul>
        <div class="sidebar-footer">
            <!-- This link now includes a parameter to ensure correct redirection -->
            <a href="../logout.php?from=admin" class="sidebar-logout-link">
                <i class="fas fa-sign-out-alt nav-icon"></i> Logout
            </a>
        </div>
    </aside>

    <!-- Main Content Area -->
    <div class="admin-main-content">
        <header class="admin-header">
            <div class="admin-profile">
                <a href="#">
                    <i class="fas fa-user-circle"></i>
                    <?php echo e($_SESSION['admin_name'] ?? 'Admin'); ?>
                </a>
            </div>
        </header>

        <!-- The content of each page will be loaded inside this div -->

