<?php
/**
 * Admin Edit Test Page
 *
 * This page provides a form for an administrator to edit an existing psychological test module.
 */

// The admin router (admin/index.php) handles the session and security checks.
include THEME_PATH . 'admin/header.php'; // Include the admin header

// 1. Get Test ID from URL and Fetch Data from Database
// -----------------------------------------------------------------------------
$test_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$test = null;
$error_message = '';

if ($test_id) {
    try {
        $pdo = get_db_connection();
        $stmt = $pdo->prepare("SELECT id, test_name, description FROM psychological_tests WHERE id = ?");
        $stmt->execute([$test_id]);
        $test = $stmt->fetch();

        if (!$test) {
            $error_message = "Test not found. It may have been deleted.";
        }
    } catch (PDOException $e) {
        $error_message = "A database error occurred: " . $e->getMessage();
    }
} else {
    $error_message = "Invalid or missing Test ID provided in the URL.";
}

?>

<div class="admin-content">
    <div class="container">
        <h1 class="page-title">Edit Psychological Test</h1>
        
        <?php if ($error_message): ?>
            <!-- Display error if test ID is invalid or test not found -->
            <p class="page-subtitle">Could not load test data.</p>
            <div class="alert alert-danger"><?php echo e($error_message); ?></div>
            <a href="index.php?page=tests" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to Test List</a>
        <?php elseif ($test): ?>
            <!-- Display the form if test is found -->
            <p class="page-subtitle">Update the details for the test: <strong><?php echo e($test['test_name']); ?></strong></p>

            <!-- Session Message Display for update success/failure -->
            <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success"><?php echo e($_SESSION['success_message']); unset($_SESSION['success_message']); ?></div>
            <?php endif; ?>
            <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger"><?php echo e($_SESSION['error_message']); unset($_SESSION['error_message']); ?></div>
            <?php endif; ?>

            <div class="form-container">
                <form action="../actions/test_management_handler.php" method="POST">
                    <!-- Hidden inputs to specify the action and the test ID -->
                    <input type="hidden" name="action" value="edit_test">
                    <input type="hidden" name="test_id" value="<?php echo e($test['id']); ?>">

                    <div class="form-group">
                        <label for="test_name">Test Name</label>
                        <input type="text" id="test_name" name="test_name" class="form-control" value="<?php echo e($test['test_name']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" class="form-control" rows="4" placeholder="Briefly describe what this test measures."><?php echo e($test['description']); ?></textarea>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Changes</button>
                        <a href="index.php?page=tests" class="btn btn-secondary">Back to Test List</a>
                    </div>
                </form>
            </div>
        <?php endif; ?>

    </div>
</div>

<?php
// Include the admin footer template.
include THEME_PATH . 'admin/footer.php';
?>

