<?php
/**
 * Admin Dashboard Page
 *
 * This is the main landing page for the administrator after logging in.
 * It displays key statistics and provides quick navigation.
 */

// The admin router (admin/index.php) handles the session and security checks.
// We can assume that if we've reached this page, the user is a logged-in admin.

// Include the admin header template.
include THEME_PATH . 'admin/header.php';

// --- DATA FETCHING FOR STATS ---
// In a real application, this logic might be in a separate model or controller,
// but for simplicity, we'll fetch it directly here.
try {
    $pdo = get_db_connection();

    // 1. Get total number of registered users.
    $total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

    // 2. Get total number of "learned" documents (CVs + Job Posters).
    $total_learned_docs = $pdo->query("SELECT COUNT(*) FROM processed_files")->fetchColumn();

    // 3. Get total number of psychological tests (Placeholder).
    // This assumes a 'psychological_tests' table exists. We'll use a placeholder for now.
    $total_tests = 0; // Replace with: $pdo->query("SELECT COUNT(*) FROM psychological_tests")->fetchColumn();
    
    // 4. Get total number of interviews conducted (Placeholder).
    $total_interviews = 0; // Replace with a query from an 'interviews' table.

} catch (PDOException $e) {
    // If database queries fail, set default values and show an error.
    $total_users = 'N/A';
    $total_learned_docs = 'N/A';
    $total_tests = 'N/A';
    $total_interviews = 'N/A';
    $db_error = "Could not fetch dashboard statistics. Error: " . $e->getMessage();
}

?>

<div class="admin-content">
    <div class="container">
        <h1 class="page-title">Admin Dashboard</h1>
        <p class="page-subtitle">Welcome back, <?php echo e($_SESSION['admin_name'] ?? 'Admin'); ?>! Here's a summary of your platform.</p>

        <?php if (isset($db_error)): ?>
            <div class="alert alert-danger"><?php echo e($db_error); ?></div>
        <?php endif; ?>

        <!-- Statistics Cards -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-users"></i></div>
                <div class="stat-info">
                    <span class="stat-number"><?php echo e($total_users); ?></span>
                    <span class="stat-label">Total Registered Users</span>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-brain"></i></div>
                <div class="stat-info">
                    <span class="stat-number"><?php echo e($total_learned_docs); ?></span>
                    <span class="stat-label">Learned Documents</span>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-file-alt"></i></div>
                <div class="stat-info">
                    <span class="stat-number"><?php echo e($total_tests); ?></span>
                    <span class="stat-label">Psychological Tests</span>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-microphone-alt"></i></div>
                <div class="stat-info">
                    <span class="stat-number"><?php echo e($total_interviews); ?></span>
                    <span class="stat-label">Interviews Conducted</span>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <h2 class="section-title">Quick Actions</h2>
            <div class="action-links">
                <a href="index.php?page=users" class="action-link">
                    <i class="fas fa-user-cog"></i>
                    <span>Manage Users</span>
                </a>
                <a href="index.php?page=tests" class="action-link">
                    <i class="fas fa-vial"></i>
                    <span>Manage Tests</span>
                </a>
                <a href="index.php?page=learning" class="action-link">
                    <i class="fas fa-sync-alt"></i>
                    <span>Update AI Learnings</span>
                </a>
                <a href="index.php?page=sessions" class="action-link">
                    <i class="fas fa-history"></i>
                    <span>View Activity</span>
                </a>
            </div>
        </div>

    </div>
</div>

<?php
// Include the admin footer template.
include THEME_PATH . 'admin/footer.php';
?>
