<?php
/**
 * Admin Add New User Page
 *
 * This page provides a form for an administrator to create a new user account manually.
 */

// The admin router (admin/index.php) handles the session and security checks.
include THEME_PATH . 'admin/header.php'; // Include the admin header

?>

<div class="admin-content">
    <div class="container">
        <h1 class="page-title">Add New User</h1>
        <p class="page-subtitle">Create a new user account. The account will be automatically verified.</p>

        <!-- Form Container -->
        <div class="form-container">
            <form action="../actions/user_management_handler.php" method="POST">
                <!-- Hidden input to specify the action -->
                <input type="hidden" name="action" value="add_user">

                <div class="form-group">
                    <label for="full_name">Full Name</label>
                    <input type="text" id="full_name" name="full_name" class="form-control" placeholder="e.g., Budi Santoso" required>
                </div>

                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" class="form-control" placeholder="e.g., budi.s@example.com" required>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" class="form-control" placeholder="Set a temporary password (min. 8 characters)" required>
                    <small class="form-text">The user can change this later. Minimum 8 characters.</small>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-success"><i class="fas fa-plus-circle"></i> Create User</button>
                    <a href="index.php?page=users" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>

    </div>
</div>

<?php
// Include the admin footer template.
include THEME_PATH . 'admin/footer.php';
?>

