<?php
/**
 * Admin Page: Add New Psychological Test
 *
 * PERBAIKAN: Path 'include' telah dikoreksi untuk mencocokkan
 * struktur file Anda (tanpa direktori 'partials').
 */

// Mengubah path dari 'admin/partials/admin_header.php'
include THEME_PATH . 'admin/header.php';
?>

<div class="content-wrapper">
    <div class="container-fluid">
        
        <div class="row mb-3">
            <div class="col-md-12">
                <h1><i class="fas fa-tasks"></i> Add New Psychological Test</h1>
                <p>Buat tes psikologi baru untuk platform.</p>
            </div>
        </div>
        
        <?php
        if (isset($_SESSION['success_message'])) {
            echo '<div class="alert alert-success">' . htmlspecialchars($_SESSION['success_message']) . '</div>';
            unset($_SESSION['success_message']);
        }
        if (isset($_SESSION['error_message'])) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($_SESSION['error_message']) . '</div>';
            unset($_SESSION['error_message']);
        }
        ?>

        <div class="card">
            <div class="card-header">
                <i class="fas fa-plus-circle"></i> New Test Details
            </div>
            <div class="card-body">
                <form action="actions/test_management_handler.php" method="POST">
                    <input type="hidden" name="action" value="add_test">

                    <div class="form-group">
                        <label for="test_name">Test Name</label>
                        <input type="text" class="form-control" id="test_name" name="test_name" 
                               placeholder="e.g., Basic Logic Test" required>
                        <small class="form-text text-muted">Nama tes yang akan dilihat oleh admin dan pengguna.</small>
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" 
                                  placeholder="A brief summary of what this test measures."></textarea>
                    </div>

                    <div class="form-group">
                        <label for="test_type">Test Type</label>
                        <select class="form-control" id="test_type" name="test_type">
                            <option value="simple" selected>
                                Simple (Manual Questions)
                            </option>
                            <option value="disc">
                                DISC (Built-in Logic)
                            </option>
                            <option value="papi">
                                PAPI Kostick (Built-in Logic)
                            </option>
                        </select>
                        <small class="form-text text-muted">
                            <b>Penting:</b> Pilih 'Simple' jika Anda ingin menambahkan pertanyaan dan skor secara manual. 
                            Pilih 'DISC' atau 'PAPI' untuk menggunakan modul tes standar yang sudah terintegrasi.
                        </small>
                    </div>
                    <hr>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Test
                    </button>
                    <a href="index.php?page=tests" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                    
                </form>
            </div>
        </div>
        
    </div> </div> <?php
// Mengubah path dari 'admin/partials/admin_footer.php'
include THEME_PATH . 'admin/footer.php';
?>