<?php
/**
 * Admin Add New Test Page
 *
 * This page provides a form for an administrator to create a new psychological test module.
 */

// The admin router (admin/index.php) handles the session and security checks.
include THEME_PATH . 'admin/header.php'; // Include the admin header

?>

<div class="admin-content">
    <div class="container">
        <h1 class="page-title">Add New Psychological Test</h1>
        <p class="page-subtitle">Create a new test module. You can add questions to it after creation.</p>

        <!-- Form Container -->
        <div class="form-container">
            <form action="../actions/test_management_handler.php" method="POST">
                <!-- Hidden input to specify the action -->
                <input type="hidden" name="action" value="add_test">

                <div class="form-group">
                    <label for="test_name">Test Name</label>
                    <input type="text" id="test_name" name="test_name" class="form-control" placeholder="e.g., Big Five Personality Test" required>
                </div>

                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea id="description" name="description" class="form-control" rows="4" placeholder="Briefly describe what this test measures."></textarea>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-success"><i class="fas fa-plus-circle"></i> Create Test</button>
                    <a href="index.php?page=tests" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>

    </div>
</div>

<?php
// Include the admin footer template.
include THEME_PATH . 'admin/footer.php';
?>


