<?php
/**
 * Partial: Formulir Tes Psikologi DISC
 *
 * File ini berisi HTML dan logika front-end untuk menampilkan
 * formulir tes DISC (model 24 atau 28 pertanyaan).
 * File ini di-include oleh file `v1/pages/psy_test.php`.
 *
 * PENTING: File ini TIDAK berisi tag <form> atau tombol submit.
 * Tag <form> dan tombol submit ada di file induknya (`psy_test.php`),
 * yang membungkus file partial ini.
 */
?>

<style>
    .disc-question-set {
        margin-bottom: 25px;
        border: 1px solid #ddd;
        border-radius: 8px;
        overflow: hidden; /* Untuk menjaga border-radius */
    }
    .disc-question-set legend {
        font-size: 1.1em;
        font-weight: bold;
        padding: 5px 15px;
        background-color: #f7f7f7;
        width: auto;
        border-bottom: 1px solid #ddd;
    }
    .disc-table {
        width: 100%;
        border-collapse: collapse;
    }
    .disc-table th, .disc-table td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }
    .disc-table th {
        background-color: #fcfcfc;
    }
    .disc-table tr:last-child td {
        border-bottom: none;
    }
    .disc-table th:nth-child(1), .disc-table td:nth-child(1) { width: 10%; text-align: center; }
    .disc-table th:nth-child(2), .disc-table td:nth-child(2) { width: 10%; text-align: center; }
    .disc-table th:nth-child(3), .disc-table td:nth-child(3) { width: 80%; }
    
    /* Meredupkan label dari radio button yang dinonaktifkan */
    input[type="radio"].disc-radio:disabled + label {
        opacity: 0.5;
        cursor: not-allowed;
    }
</style>

<div class="test-instructions mb-4">
    <h4>Petunjuk Pengerjaan Tes DISC</h4>
    <p>Di setiap set pertanyaan berikut, terdapat empat kata sifat. Tugas Anda adalah:</p>
    <ul>
        <li>Pilih satu kata yang <strong>Paling Menggambarkan Diri Anda (Most)</strong>.</li>
        <li>Pilih satu kata yang <strong>Paling Tidak Menggambarkan Diri Anda (Least)</strong>.</li>
    </ul>
    <p>Anda harus memilih dua kata yang berbeda untuk setiap set. Tidak boleh ada jawaban yang dikosongkan.</p>
</div>

<hr>

<fieldset class="disc-question-set">
    <legend>Pertanyaan 1 dari 24</legend>
    <table class="disc-table">
        <thead>
            <tr>
                <th>Most</th>
                <th>Least</th>
                <th>Deskripsi</th>
            </tr>
        </thead>
        <tbody>
            <?php $q_num = 1; // Nomor pertanyaan untuk grup nama radio ?>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="A" required></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="A" required></td>
                <td><label>Penuh Petualangan, Berani</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="B"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="B"></td>
                <td><label>Persuasif, Mudah Bergaul</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="C"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="C"></td>
                <td><label>Sabar, Tenang</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="D"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="D"></td>
                <td><label>Akurat, Berhati-hati</label></td>
            </tr>
        </tbody>
    </table>
</fieldset>

<fieldset class="disc-question-set">
    <legend>Pertanyaan 2 dari 24</legend>
    <table class="disc-table">
        <thead>
            <tr>
                <th>Most</th>
                <th>Least</th>
                <th>Deskripsi</th>
            </tr>
        </thead>
        <tbody>
            <?php $q_num = 2; // Nomor pertanyaan untuk grup nama radio ?>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="A" required></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="A" required></td>
                <td><label>Antusias, Ekspresif</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="B"></td>
                <td><input type="radio" class_G[least]" value="B"></td>
                <td><label>Tegas, Suka Mengontrol</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="C"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="C"></td>
                <td><label>Sistematis, Logis</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="D"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="D"></td>
                <td><label>Baik Hati, Penuh Perasaan</label></td>
            </tr>
        </tbody>
    </table>
</fieldset>

<fieldset class="disc-question-set">
    <legend>Pertanyaan 3 dari 24</legend>
    <table class="disc-table">
        <thead>
            <tr>
                <th>Most</th>
                <th>Least</th>
                <th>Deskripsi</th>
            </tr>
        </thead>
        <tbody>
            <?php $q_num = 3; // Nomor pertanyaan untuk grup nama radio ?>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="A" required></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="A" required></td>
                <td><label>Pendiam, Tertutup</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="B"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="B"></td>
                <td><label>Optimis, Ceria</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="C"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="C"></td>
                <td><label>Teguh, Keras Kepala</label></td>
            </tr>
            <tr>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[most]" value="D"></td>
                <td><input type="radio" class="disc-radio" name="disc_q<?php echo $q_num; ?>[least]" value="D"></td>
                <td><label>Perseptif, Analitis</label></td>
            </tr>
        </tbody>
    </table>
</fieldset>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // Ambil semua radio button di dalam formulir DISC
    const allRadios = document.querySelectorAll('input[type="radio"].disc-radio');

    allRadios.forEach(radio => {
        radio.addEventListener('change', function () {
            if (this.checked) {
                // Dapatkan nama grup (cth: "disc_q1[most]") dan nilai (cth: "A")
                const name = this.name;
                const value = this.value;
                
                let oppositeName;

                // Tentukan nama grup lawannya
                if (name.includes('[most]')) {
                    oppositeName = name.replace('[most]', '[least]');
                } else {
                    oppositeName = name.replace('[least]', '[most]');
                }

                // Temukan semua radio di grup lawan
                const oppositeRadios = document.querySelectorAll(`input[name="${oppositeName}"]`);

                oppositeRadios.forEach(oppRadio => {
                    if (oppRadio.value === value) {
                        // Jika ini adalah radio lawan dengan nilai yang sama,
                        // nonaktifkan (disable).
                        oppRadio.disabled = true;
                        
                        // Jika kebetulan radio lawan itu sedang ter-check,
                        // hapus centangnya.
                        if (oppRadio.checked) {
                            oppRadio.checked = false;
                        }
                    } else {
                        // Aktifkan kembali radio lain di grup lawan
                        oppRadio.disabled = false;
                    }
                });
            }
        });
    });
});
</script>