<?php
/**
 * Google Single Sign-On (SSO) Initiator
 *
 * This script starts the Google login/registration process for a regular user.
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';
require_once 'vendor/autoload.php';

// 1. Create Google Client instance
$client = new Google_Client();
$client->setAuthConfig('credentials.json');
$client->setRedirectUri(GOOGLE_REDIRECT_URI);
$client->setAccessType('offline');
$client->addScope("email");
$client->addScope("profile");

// 2. Store the intended action in the session
// This tells our callback handler what to do after Google authentication.
$_SESSION['oauth_action'] = 'user_login';

// 3. Generate the authentication URL and redirect the user
$authUrl = $client->createAuthUrl();
header('Location: ' . $authUrl);
exit();
