<?php
/**
 * Scorer Logika Tes Psikologi PAPI Kostick
 *
 * File ini berisi logika inti (yang berasal dari formula Excel Anda)
 * untuk mengubah jawaban mentah tes PAPI (90 pertanyaan) dari pengguna
 * menjadi laporan skor mentah untuk 20 faset.
 *
 * File ini dipanggil oleh: v1/actions/submit_psychotest_handler.php
 */

/**
 * Menghitung skor mentah 20 faset PAPI Kostick dari array jawaban.
 *
 * @param array $answers Array jawaban yang diterima dari $_POST.
 * Format yang diharapkan:
 * [
 * 'papi_q' => [
 * 1 => 'A',
 * 2 => 'B',
 * 3 => 'A',
 * ...
 * 90 => 'B'
 * ]
 * ]
 *
 * @return array Array terstruktur yang berisi skor mentah untuk setiap faset.
 */
function calculatePapiReport(array $answers): array
{
    // Ambil array utama dari jawaban PAPI
    $userChoices = $answers['papi_q'] ?? [];

    // =======================================================================
    // KUNCI JAWABAN (WAJIB DISESUAIKAN DENGAN FILE EXCEL ANDA)
    // =======================================================================
    
    /**
     * Daftar 20 Faset PAPI Kostick
     * G - Hard worker
     * L - Leadership
     * I - Decision Making
     * T - Pace/Vigorous
     * V - Active
     * S - Social Extension
     * R - Theoretical
     * D - Detail
     * C - Organized
     * E - Emotional Restraint
     * N - Need to Finish Task
     * A - Need to Achieve
     * P - Need to Control Others
     * X - Need to be Noticed
     * B - Need for Approval (Belonging)
     * O - Need for Closeness
     * K - Need to be Aggressive
     * F - Need to Support Authority
     * W - Need to Follow Rules
     * Z - Need for Change
     */

    /**
     * Peta Skor PAPI Kostick.
     * Setiap pertanyaan (1-90) membandingkan dua faset.
     * Format: [Nomor Pertanyaan] => ['A' => 'FASET_UNTUK_A', 'B' => 'FASET_UNTUK_B']
     * * !!! INI HANYA CONTOH - ANDA HARUS MENGGANTINYA DENGAN KUNCI DARI EXCEL ANDA !!!
     */
    $papiScoringMap = [
        // Contoh berdasarkan file psy_test_papi.php yang saya buat:
        1  => ['A' => 'G', 'B' => 'E'], // G: Pekerja Keras vs E: Tdk Pemurung
        2  => ['A' => 'A', 'B' => 'L'], // A: Bekerja lbh baik vs L: Menunjukkan cara
        3  => ['A' => 'T', 'B' => 'N'], // T: Coba hal baru vs N: Bereskan s/d selesai
        4  => ['A' => 'O', 'B' => 'L'], // O: Berteman dekat vs L: Pemimpin baik
        5  => ['A' => 'R', 'B' => 'C'], // R: Ide baru vs C: Teratur
        6  => ['A' => 'S', 'B' => 'V'], // Faset S vs V (Contoh)
        7  => ['A' => 'P', 'B' => 'I'], // Faset P vs I (Contoh)
        8  => ['A' => 'X', 'B' => 'D'], // Faset X vs D (Contoh)
        9  => ['A' => 'Z', 'B' => 'K'], // Faset Z vs K (Contoh)
        10 => ['A' => 'F', 'B' => 'W'], // Faset F vs W (Contoh)
        // ...
        // ... Lanjutkan untuk semua 90 pertanyaan ...
        // ...
        88 => ['A' => 'E', 'B' => 'I'], // E: Mudah cemas (inverse) vs I: Ambil keputusan
        89 => ['A' => 'D', 'B' => 'F'], // D: Detil vs F: Menyenangkan atasan
        90 => ['A' => 'V', 'B' => 'G'], // V: Bersemangat vs G: Berusaha keras
    ];

    // =======================================================================
    // PROSES PERHITUNGAN SKOR
    // =======================================================================

    // 1. Inisialisasi wadah skor untuk semua 20 faset
    $rawScores = [
        'G' => 0, 'L' => 0, 'I' => 0, 'T' => 0, 'V' => 0, 'S' => 0, 'R' => 0, 
        'D' => 0, 'C' => 0, 'E' => 0, 'N' => 0, 'A' => 0, 'P' => 0, 'X' => 0, 
        'B' => 0, 'O' => 0, 'K' => 0, 'F' => 0, 'W' => 0, 'Z' => 0,
    ];

    // 2. Loop melalui semua 90 pertanyaan
    for ($q_num = 1; $q_num <= 90; $q_num++) {
        
        // Periksa apakah pertanyaan ini ada di peta skor (seharusnya ada)
        if (isset($papiScoringMap[$q_num])) {
            
            // Ambil pilihan pengguna untuk pertanyaan ini
            $choice = $userChoices[$q_num] ?? null; // cth: 'A' atau 'B'
            
            if ($choice === 'A') {
                // Pengguna memilih A. Cari faset yang sesuai.
                $facet = $papiScoringMap[$q_num]['A']; // cth: 'G'
                if (isset($rawScores[$facet])) {
                    $rawScores[$facet]++; // Tambahkan 1 poin ke faset G
                }
            } elseif ($choice === 'B') {
                // Pengguna memilih B. Cari faset yang sesuai.
                $facet = $papiScoringMap[$q_num]['B']; // cth: 'E'
                if (isset($rawScores[$facet])) {
                    $rawScores[$facet]++; // Tambahkan 1 poin ke faset E
                }
            }
            // Jika $choice adalah null (tidak dijawab), tidak ada poin yang ditambahkan
        }
    }
    
    // =======================================================================
    // KEMBALIKAN HASIL
    // =======================================================================

    // Hasilnya adalah array skor mentah.
    // Di PAPI, skor mentah ini (biasanya 0-9) kemudian
    // diplot ke "PAPI Wheel" untuk interpretasi.
    // Kita simpan skor mentah ini di database.
    
    $result = [
        'raw_scores' => $rawScores,
        'summary_text' => 'PAPI Kostick Raw Scores Calculated.'
        // Anda bisa tambahkan logika konversi norma atau
        // interpretasi di sini jika file Excel Anda memilikinya.
    ];

    // Fungsi ini akan mengembalikan array PHP.
    // Handler (submit_psychotest_handler.php) akan
    // mengubahnya menjadi JSON untuk disimpan di database.
    return $result;
}