<?php
/**
 * Admin Panel Front Controller
 *
 * This is the single entry point for the entire admin section.
 * It handles security, session management, and routing to the correct admin page.
 */

// Start the session at the very beginning of the script.
session_start();

// 1. INITIALIZATION & BOOTSTRAPPING
// -----------------------------------------------------------------------------
require_once '../config.php';
require_once '../vendor/autoload.php';
require_once '../app/helpers.php';


// 2. ROUTING & SECURITY
// -----------------------------------------------------------------------------
$page = $_GET['page'] ?? 'dashboard';

// THE SECURITY GATE
if (!is_admin() && $page !== 'login') {
    header('Location: index.php?page=login');
    exit();
}


// 3. PAGE LOADING & RENDERING
// -----------------------------------------------------------------------------

// Create a "whitelist" of all valid pages in the admin theme directory.
// FIXED: Added the missing pages for test management to the allowed list.
$allowed_pages = [
    'dashboard',
    'login',
    'users',
    'add_user',
    'edit_user',
    'tests',
    'add_test',         // <-- Ditambahkan
    'edit_test',        // <-- Ditambahkan
    'manage_questions', // <-- Ditambahkan
    'learning',
    'sessions'
];

// Check if the requested page from the URL is in our list of allowed pages.
if (in_array($page, $allowed_pages)) {
    // If it's allowed, construct the full server path to the theme file.
    $page_path = THEME_PATH . 'admin/' . $page . '.php';

    // As a final check, verify that the file actually exists on the server.
    if (file_exists($page_path)) {
        include $page_path;
    } else {
        // This is a developer error state.
        http_response_code(500);
        die("FATAL ERROR: The view file for the page '{$page}' is missing at: {$page_path}");
    }
} else {
    // If the page requested in the URL is NOT in our whitelist, it's an invalid request.
    http_response_code(404);
    // Redirect to the dashboard to prevent errors and for security.
    header('Location: index.php?page=dashboard');
    exit();
}

